/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe;

import com.google.common.reflect.Reflection;
import com.mojang.brigadier.CommandDispatcher;
import dev.doctor4t.wathe.block.DoorPartBlock;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.command.ForceRoleCommand;
import dev.doctor4t.wathe.command.GameSettingsCommand;
import dev.doctor4t.wathe.command.GiveRoomKeyCommand;
import dev.doctor4t.wathe.command.LockToSupportersCommand;
import dev.doctor4t.wathe.command.MapVariablesCommand;
import dev.doctor4t.wathe.command.SetMoneyCommand;
import dev.doctor4t.wathe.command.SetTimerCommand;
import dev.doctor4t.wathe.command.SetVisualCommand;
import dev.doctor4t.wathe.command.StartCommand;
import dev.doctor4t.wathe.command.StopCommand;
import dev.doctor4t.wathe.command.argument.GameModeArgumentType;
import dev.doctor4t.wathe.command.argument.MapEffectArgumentType;
import dev.doctor4t.wathe.command.argument.TimeOfDayArgumentType;
import dev.doctor4t.wathe.game.GameConstants;
import dev.doctor4t.wathe.index.WatheBlockEntities;
import dev.doctor4t.wathe.index.WatheBlocks;
import dev.doctor4t.wathe.index.WatheDataComponentTypes;
import dev.doctor4t.wathe.index.WatheEntities;
import dev.doctor4t.wathe.index.WatheItems;
import dev.doctor4t.wathe.index.WatheParticles;
import dev.doctor4t.wathe.index.WatheSounds;
import dev.doctor4t.wathe.util.AnnounceEndingPayload;
import dev.doctor4t.wathe.util.AnnounceWelcomePayload;
import dev.doctor4t.wathe.util.GunDropPayload;
import dev.doctor4t.wathe.util.GunShootPayload;
import dev.doctor4t.wathe.util.KnifeStabPayload;
import dev.doctor4t.wathe.util.NoteEditPayload;
import dev.doctor4t.wathe.util.PoisonUtils;
import dev.doctor4t.wathe.util.Scheduler;
import dev.doctor4t.wathe.util.ShootMuzzleS2CPayload;
import dev.doctor4t.wathe.util.StoreBuyPayload;
import dev.doctor4t.wathe.util.TaskCompletePayload;
import dev.upcraft.datasync.api.DataSyncAPI;
import dev.upcraft.datasync.api.util.Entitlements;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2319;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wathe
implements ModInitializer {
    public static final String MOD_ID = "wathe";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"wathe");
    public static final class_2960 COMMAND_ACCESS = Wathe.id("commandaccess");

    @NotNull
    public static class_2960 id(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public void onInitialize() {
        GameConstants.init();
        Reflection.initialize((Class[])new Class[]{WatheDataComponentTypes.class});
        WatheSounds.initialize();
        WatheEntities.initialize();
        WatheBlocks.initialize();
        WatheItems.initialize();
        WatheBlockEntities.initialize();
        WatheParticles.initialize();
        ArgumentTypeRegistry.registerArgumentType((class_2960)Wathe.id("timeofday"), TimeOfDayArgumentType.class, (class_2314)class_2319.method_41999(TimeOfDayArgumentType::timeofday));
        ArgumentTypeRegistry.registerArgumentType((class_2960)Wathe.id("gamemode"), GameModeArgumentType.class, (class_2314)class_2319.method_41999(GameModeArgumentType::gameMode));
        ArgumentTypeRegistry.registerArgumentType((class_2960)Wathe.id("mapeffect"), MapEffectArgumentType.class, (class_2314)class_2319.method_41999(MapEffectArgumentType::mapEffect));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            MapVariablesCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GameSettingsCommand.register((CommandDispatcher<class_2168>)dispatcher);
            GiveRoomKeyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            StartCommand.register((CommandDispatcher<class_2168>)dispatcher);
            StopCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetVisualCommand.register((CommandDispatcher<class_2168>)dispatcher);
            ForceRoleCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetTimerCommand.register((CommandDispatcher<class_2168>)dispatcher);
            SetMoneyCommand.register((CommandDispatcher<class_2168>)dispatcher);
            LockToSupportersCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerPlayerEvents.JOIN.register(player -> DataSyncAPI.refreshAllPlayerData((UUID)player.method_5667()).thenRunAsync(() -> {
            if (((GameWorldComponent)GameWorldComponent.KEY.get((Object)player.method_37908())).isLockedToSupporters() && !Wathe.isSupporter((class_1657)player).booleanValue()) {
                player.field_13987.method_52396((class_2561)class_2561.method_43470((String)"Server is reserved to doctor4t supporters."));
            }
        }, (Executor)player.method_37908().method_8503()));
        PayloadTypeRegistry.playS2C().register(ShootMuzzleS2CPayload.ID, ShootMuzzleS2CPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PoisonUtils.PoisonOverlayPayload.ID, PoisonUtils.PoisonOverlayPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(GunDropPayload.ID, GunDropPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(TaskCompletePayload.ID, TaskCompletePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(AnnounceWelcomePayload.ID, AnnounceWelcomePayload.CODEC);
        PayloadTypeRegistry.playS2C().register(AnnounceEndingPayload.ID, AnnounceEndingPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(KnifeStabPayload.ID, KnifeStabPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(GunShootPayload.ID, GunShootPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(StoreBuyPayload.ID, StoreBuyPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(NoteEditPayload.ID, NoteEditPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(KnifeStabPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)new KnifeStabPayload.Receiver());
        ServerPlayNetworking.registerGlobalReceiver(GunShootPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)new GunShootPayload.Receiver());
        ServerPlayNetworking.registerGlobalReceiver(StoreBuyPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)new StoreBuyPayload.Receiver());
        ServerPlayNetworking.registerGlobalReceiver(NoteEditPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)new NoteEditPayload.Receiver());
        Scheduler.init();
    }

    public static boolean isSkyVisibleAdjacent(@NotNull class_1297 player) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338 playerPos = class_2338.method_49638((class_2374)player.method_33571());
        for (int x = -1; x <= 1; x += 2) {
            for (int z = -1; z <= 1; z += 2) {
                mutable.method_10103(playerPos.method_10263() + x, playerPos.method_10264(), playerPos.method_10260() + z);
                if (!player.method_37908().method_8311((class_2338)mutable)) continue;
                return !(player.method_37908().method_8320(playerPos).method_26204() instanceof DoorPartBlock);
            }
        }
        return false;
    }

    public static boolean isExposedToWind(@NotNull class_1297 player) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338 playerPos = class_2338.method_49638((class_2374)player.method_33571());
        for (int x = 0; x <= 10; ++x) {
            mutable.method_10102((double)(playerPos.method_10263() - x), player.method_33571().method_10214(), (double)playerPos.method_10260());
            if (player.method_37908().method_8311((class_2338)mutable)) continue;
            return false;
        }
        return true;
    }

    public static int executeSupporterCommand(class_2168 source, Runnable runnable) {
        class_3222 player = source.method_44023();
        if (player == null || !player.getClass().equals(class_3222.class)) {
            return 0;
        }
        if (Wathe.isSupporter((class_1657)player).booleanValue() || FabricLoader.getInstance().isDevelopmentEnvironment()) {
            runnable.run();
            return 1;
        }
        player.method_43496((class_2561)class_2561.method_43471((String)"commands.supporter_only"));
        return 0;
    }

    @NotNull
    public static Boolean isSupporter(class_1657 player) {
        Optional entitlements = Entitlements.token().get(player.method_5667());
        return entitlements.map(value -> value.keys().stream().anyMatch(identifier -> identifier.equals((Object)COMMAND_ACCESS))).orElse(false);
    }
}

